<?php

namespace Tests\Feature;

use App\Models\Tenant;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class TenantAuthTest extends TestCase
{
    use RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        // Apply tenant middleware for all tests
        $this->withMiddleware(\App\Http\Middleware\TenantMiddleware::class);
    }

    public function test_registration_creates_tenant_and_user()
    {
        $response = $this->post('/register', [
            'name' => 'Test User',
            'email' => 'testuser@example.com',
            'password' => 'password',
            'password_confirmation' => 'password',
            'tenant_name' => 'Test Tenant',
            'tenant_domain' => 'testtenant.com',
            'tenant_subdomain' => 'testsub',
        ]);

        $response->assertRedirect(route('dashboard'));

        $this->assertDatabaseHas('tenants', [
            'name' => 'Test Tenant',
            'domain' => 'testtenant.com',
            'subdomain' => 'testsub',
        ]);

        $this->assertDatabaseHas('users', [
            'email' => 'testuser@example.com',
        ]);

        $user = User::where('email', 'testuser@example.com')->first();
        $this->assertEquals('Test Tenant', $user->tenant->name);
    }

}
